/* ---------------------------------------------------------------------------
** This software is in the public domain, furnished "as is", without technical
** support, and with no warranty, express or implied, as to its usefulness for
** any purpose.
**
** The software creates an interactive user interface through which the user
** can remotely control and monitor the SHASbot surveillance vehicle functions.
** It uses the ipcapture library for capturing and displaying an mjpeg stream 
** via an IP webcam. It uses the controlp5 library for various GUI components
** and interfaces. It uses the prcessing.serial library for serial comm. 
**
** Author: Charles Grubbs
** -------------------------------------------------------------------------*/

import ipcapture.*;
import controlP5.*;
import processing.serial.*;

Serial myPort;    //creates a Serial port object

IPCapture cam;    //creates an IPCapture object
ControlP5 cp5;    //creates an instance of ControlP5
Button fw, dn, lf, rt, cl, cr; //creates arrow buttons for vehicle and camera control
CallbackListener cb; //Creates a callback listener to check and respond when a cp5 button is pressed/released

boolean fdrive = false; //variables to check if the vehicle is currently being commanded to move forward/backward
boolean bdrive = false;

int mic1 = 10;    //audio detection spl variables
int mic2 = 10;

void setup() {
  size(900,900);
  noStroke();
  
  cp5 = new ControlP5(this); //declares a new instance of cp5
  
  PImage[] imgs1 = {loadImage("unpushed_u.png"),loadImage("h_unpushed_u.png"),loadImage("pushed_u.png")}; //loads button images
  PImage[] imgs2 = {loadImage("unpushed_d.png"),loadImage("h_unpushed_d.png"),loadImage("pushed_d.png")};
  PImage[] imgs3 = {loadImage("unpushed_l.png"),loadImage("h_unpushed_l.png"),loadImage("pushed_l.png")};
  PImage[] imgs4 = {loadImage("unpushed_r.png"),loadImage("h_unpushed_r.png"),loadImage("pushed_r.png")};

  
  fw = cp5.addButton("forward") //add vehicle forward button to the GUI
    .setValue(0)
    .setPosition(650, 550)
    .setSize(100,100)
    .setImages(imgs1)
    .activateBy(ControlP5.PRESSED)
    ;
    
  dn = cp5.addButton("backward")//add vehicle backward button to the GUI
    .setValue(1)
    .setPosition(650, 750)
    .setSize(100,100)
    .setImages(imgs2)
    .activateBy(ControlP5.PRESSED)
    ;
    
  lf = cp5.addButton("lefty") //add vehicle left button to the GUI
    .setValue(2)
    .setPosition(550, 650)
    .setSize(100,100)
    .setImages(imgs3)
    .activateBy(ControlP5.PRESSED)
    ;
    
  rt = cp5.addButton("righty")//add vehicle right button to the GUI
    .setValue(3)
    .setPosition(750, 650)
    .setSize(100,100)
    .setImages(imgs4)
    .activateBy(ControlP5.PRESSED)
    ;
    
  cl = cp5.addButton("cam_left") //add cam pan left button to the GUI
    .setValue(200)
    .setPosition(50, 650)
    .setSize(100,100)
    .setImages(imgs3)
    .activateBy(ControlP5.PRESSED)
    ;
    
  cr = cp5.addButton("cam_right") //add cam pan right button to the GUI
    .setValue(300)
    .setPosition(250, 650)
    .setSize(100,100)
    .setImages(imgs4)
    .activateBy(ControlP5.PRESSED)
    ;
  
 /* cb = new CallbackListener(){
  
    public void controlEvent(CallbackEvent theEvent){
    
      switch(theEvent.getAction()){ //if an action is taken by the user, retrieve it
      
        case(ControlP5.ACTION_PRESSED): //if a button on the GUI is pressed
        break;
        
        case(ControlP5.ACTION_RELEASED): //if a button on the GUI is released
        break;
      }
    }
  };
  
  cp5.addCallback(cb); //add callback to the gui*/
  

  
  cam = new IPCapture(this, "http://192.168.1.123/img/video.mjpeg", "username", "password"); //declare instance of IPCapture by giving the http URL of the mjpeg stream
  cam.start(); //initialize the mjpeg stream
  
  println(Serial.list()); //print available serial ports

  myPort = new Serial(this, Serial.list()[0], 9600);  
}

void draw() {
  if(cam.isAvailable()) {
    cam.read();
    image(cam,130,30); //position the camera image
  }
  
   if(myPort.isAvailable()){
     mic1 = myPort.read();
  
     if(mic1 == 11){
      //level 1
      }
  
     else if(mic1 == 12){
      //level 2
      }
  
     else if(mic1 == 13){
      //level 3
      }
  
   }

  
}

void keyPressed(){ //overrides the keyPressed() function
   
  if(fdrive){ //if the vehicle is still currently being told to move forward
    if(keyCode==LEFT){ //if the 'left' key has been pressed
       myPort.write(3); //turn left
       myPort.write(2); //move forward
       lf.setImage(loadImage("pushed_l.png"));
      }
        
    else if(keyCode==RIGHT){ //if the 'right' key has been pressed
      myPort.write(4); //turn right
      myPort.write(2); //move forward
      rt.setImage(loadImage("pushed_r.png"));
    }
      
    
  } 
  
  else if(bdrive){ //if the vehicle is still currently being told to move backward
    if(keyCode==LEFT){
       myPort.write(3); //turn left
       myPort.write(1); //move backward
       lf.setImage(loadImage("pushed_l.png"));
      }
        
    else if(keyCode==RIGHT){
      myPort.write(4); //turn right
      myPort.write(1); //move backward
      rt.setImage(loadImage("pushed_r.png"));
    }
      
    
  }
  
  else{
      if(keyCode==DOWN){
      myPort.write(1); //move backward
      bdrive = true; //set status variable that states we are now being told to move backward
      dn.setImage(loadImage("pushed_d.png"));
      }
      
     else if (keyCode==UP){
     myPort.write(2); //move forward
     fdrive = true; //set status variable that states we are now being told to move forward
     fw.setImage(loadImage("pushed_u.png"));
     }
     
     else if(keyCode==LEFT){
       myPort.write(3); //turn left
       lf.setImage(loadImage("pushed_l.png"));
      }
        
    else if(keyCode==RIGHT){
      myPort.write(4); //turn right
      rt.setImage(loadImage("pushed_r.png"));
    }
    
    //THIS FOLLOWING ELSE STATEMENT WILL NEED TO BE DELETED IF ANY OTHER KEYS ARE TO BE USED<<<*************************
    else{ //IF ANY OTHER KEY IS PUSHED
    myPort.write(5); //STOP
       fdrive = false; //we are no longer moving fwd
       bdrive = false; //we are no longer moving bwd
    }
  }
}

void keyReleased(){//overrides the keyReleased() function
  
  if(keyCode==LEFT || keyCode==RIGHT){//if we have released the left or right keys
    myPort.write(6); //auto-correct the steering
    rt.setImage(loadImage("unpushed_r.png"));
    lf.setImage(loadImage("unpushed_l.png"));
  }
  
  else if(keyCode==UP || keyCode==DOWN){//if we have released the fwd/bwd keys
    myPort.write(5); //STOP
    fdrive = false; //we are no longer moving fwd/bwd
    bdrive = false;
    dn.setImage(loadImage("unpushed_d.png"));
    fw.setImage(loadImage("unpushed_u.png"));
  }
  
  //THIS FOLLOWING ELSE STATEMENT WILL NEED TO BE DELETED IF ANY OTHER KEYS ARE TO BE USED<<<*************************
  else{ //if any other key is released
    myPort.write(6); //auto-correct steering
    myPort.write(5); //STOP
    rt.setImage(loadImage("unpushed_r.png"));
    lf.setImage(loadImage("unpushed_l.png"));
    dn.setImage(loadImage("unpushed_d.png"));
    fw.setImage(loadImage("unpushed_u.png"));
  }
  
}



void controlEvent(CallbackEvent theEvent) {//if an event happens
  if (theEvent.getController().equals(fw)) {//if the vehicle forward button is interacted with
    switch(theEvent.getAction()) {
      case(ControlP5.ACTION_PRESSED): //if the button has been pressed
      //println("forward");
      myPort.write(2); //move fwd
      break;
      case(ControlP5.ACTION_RELEASED): //if released
      //println("stop");
      myPort.write(5); //stop
      myPort.write(6); //auto-correct steering
      break;
    }
  }
  else if (theEvent.getController().equals(dn)) {//if the vehicle backward button is interacted with
    switch(theEvent.getAction()) {
      case(ControlP5.ACTION_PRESSED): //if the button has been pressed
      //println("backward");
      myPort.write(1); //move backward
      break;
      case(ControlP5.ACTION_RELEASED): //if released
     // println("stop");
      myPort.write(5); //stop
      myPort.write(6); //auto-correct steering
      break;
    }
  }
  else if (theEvent.getController().equals(lf)) {//if the vehicle left button is interacted with
    switch(theEvent.getAction()) {
      case(ControlP5.ACTION_PRESSED): 
      //println("left");
      myPort.write(3);
      delay(2);
      break;
      case(ControlP5.ACTION_RELEASED): 
     // println("stop");
      myPort.write(5); //stop
      myPort.write(6); //auto-correct steering
      break;
    }
  }
  else if (theEvent.getController().equals(rt)) { //if the vehicle right button is interacted with
    switch(theEvent.getAction()) {
      case(ControlP5.ACTION_PRESSED): 
      //println("right");
      myPort.write(4);
      delay(2);
      break;
      case(ControlP5.ACTION_RELEASED): 
      //println("stop");
      myPort.write(5); //stop
      myPort.write(6);//auto-correct steering
      break;
    }
  }
  
  else               //if no other component on the gui is interacted with ***********************************************************************
    myPort.write(5); //stop
}


public void forward(int theValue){
 //myPort.write(2);
}

public void backward(int theValue){
 // myPort.write(1); 

}

public void lefty(int theValue){
 // myPort.write(3);

}

public void righty(int theValue){
  //myPort.write(4);
}
